/*
 * Decompiled with CFR 0.152.
 */
package com.andavin.images.command;

import com.andavin.images.command.BaseCommand;
import com.andavin.images.command.CommandExecutor;
import com.andavin.images.command.ImageCommand;
import com.andavin.reflect.Reflection;
import com.andavin.reflect.exception.UncheckedReflectiveOperationException;
import com.andavin.util.Logger;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.SimpleCommandMap;

public final class CommandRegistry {
    private static final CommandMap COMMAND_MAP = (CommandMap)Reflection.invokeMethod(Bukkit.getServer().getClass(), (Object)Bukkit.getServer(), "getCommandMap", new Object[0]);

    public static void registerCommands() {
        CommandRegistry.register(new ImageCommand());
    }

    public static void register(BaseCommand command) {
        Logger.debug("Registering command {}.", command);
        CommandRegistry.clearCommand(command);
        COMMAND_MAP.register("images", (Command)new CommandExecutor(command));
    }

    private static void clearCommand(BaseCommand command) {
        try {
            Map commands = (Map)Reflection.getFieldValue(SimpleCommandMap.class, COMMAND_MAP, "knownCommands");
            commands.remove(command.getName().toLowerCase());
            for (String alias : command.getAliases()) {
                commands.remove(alias.toLowerCase());
            }
        }
        catch (UncheckedReflectiveOperationException e) {
            Logger.severe(e);
        }
    }
}

